--
--  Copyright 2011 Autodesk, Inc. All rights reserved.
--

rollout DYNlampParams ""
(
  ---SECTION 1 - SET UP LOCAL VARIABLES---
  local LOCobj
  local LOCallowHeight = 0.0

  ---SECTION 2 - DEFINE LOCAL FUNCTIONS---
  fn DYNFUNvspLampFilter       FUNobj = (classof FUNobj.baseObject == VSP_Lamp)

  fn DYNFUNcalcColumnHeadHeight FUNrad FUNang FUNlen =
  (
    local LOCdist = ((Sin FUNang) * FUNrad) + ((Sin (90.0 - FUNang)) * FUNlen)
  )

  fn DYNFUNlampSpinnerLimits FUNobj FUNallowHeight =
  (
    --- Calc Max allowed Arm Length
    local x      = FUNobj.baseObject.height - (FUNobj.baseObject.kink1 + FUNobj.baseObject.kink2 + 0.1) - ((sin FUNobj.baseObject.angle) * FUNobj.baseObject.radius)

    --- Calculate Max Allowed Bend Radius
    local y      = FUNobj.baseObject.height - (FUNobj.baseObject.kink1 + FUNobj.baseObject.kink2 + 0.1) - ((sin (90 - FUNobj.baseObject.angle)) * FUNobj.baseObject.armLen)

    --- Constants
    local Th1    = atan (FUNobj.baseObject.armLen / FUNobj.baseObject.radius)
    local u      = FUNobj.baseObject.radius / (cos Th1)
    local zReqd  = (sin (180 - (Th1 + 10))) * u
    local zAvail = FUNobj.baseObject.height - (FUNobj.baseObject.kink1 + FUNobj.baseObject.kink2 + 0.1)

    --- Calc Min Allowable Bend Angle
    if zReqd <= zAvail then (DYNlampParams.SPDYNangle.range.x = 10.0)
  )

  fn DYNFUNlampParams FUNobj =
  (
    FUNobj.baseObject.height            = FUNobj.baseObject.height
    DYNlampParams.LOCallowHeight        = DYNlampParams.DYNFUNcalcColumnHeadHeight FUNobj.baseObject.radius FUNobj.baseObject.angle FUNobj.baseObject.armLen

    DYNlampParams.LOCobj                = FUNobj
    DYNlampParams.SPDYNheight.value     = FUNobj.baseObject.height
    DYNlampParams.SPDYNdepth.value      = FUNobj.baseObject.depth
    DYNlampParams.SPDYNkink1.value      = FUNobj.baseObject.kink1
    DYNlampParams.SPDYNkink2.value      = FUNobj.baseObject.kink2
    DYNlampParams.CKDYNonOff.checked    = FUNobj.baseObject.onOff
    DYNlampParams.SPDYNdia1.value       = FUNobj.baseObject.dia1
    DYNlampParams.SPDYNdia2.value       = FUNobj.baseObject.dia2
    DYNlampParams.SPDYNradius.value     = FUNobj.baseObject.radius
    DYNlampParams.SPDYNarmLen.value     = FUNobj.baseObject.armLen
    DYNlampParams.SPDYNangle.value      = FUNobj.baseObject.angle
    DYNlampParams.SPDYNheadScaleX.value = FUNobj.baseObject.headScaleX
    DYNlampParams.SPDYNheadScaleY.value = FUNobj.baseObject.headScaleY * 0.25
    DYNlampParams.CKDYNleftArm.checked  = FUNobj.baseObject.leftArm
    DYNlampParams.CKDYNrightArm.checked = FUNobj.baseObject.rightArm

    --- Set Up Spinner Limits
    DYNlampParams.DYNFUNlampSpinnerLimits FUNobj DYNlampParams.LOCallowHeight

    --- Get current Material
    local LOCmatArray = DYNFUNgetMatChannelNames FUNobj.material true true DYNINImatIDlimit
    if LOCmatArray.count > 10 then (for i = LOCmatArray.count to 11 by -1 do deleteItem LOCmatArray i)
    DYNlampParams.DDDYNtype.items      = LOCmatArray
    if LOCmatArray.count > 0 then
    (
      local LOCmatID = if (FUNobj.baseObject.matID) > DYNlampParams.DDDYNtype.items.count then DYNlampParams.DDDYNtype.items.count else (FUNobj.baseObject.matID)
      FUNobj.baseObject.matID = LOCmatID
      DYNlampParams.DDDYNtype.selection  = FUNobj.baseObject.matID
      DYNlampParams.DDDYNtype.enabled    = true
    )
    else DYNlampParams.DDDYNtype.enabled = false

    --- Check whether other instances exist
    DYNFUNgatherInstancesOfNode DYNlampParams FUNobj
  )


  ---SECTION 3 - DEFINE PANEL LAYOUT---
  groupbox GBDYN01 width:(DYNiniExplorerWidth - 21) height:47  pos:[4,7]
  dropdownlist DDDYNtype width:(DYNiniExplorerWidth - 39) pos:[13,26]

  groupbox GBDYN02 width:(DYNiniExplorerWidth - 21) height:146 pos:[4,59]
  label LBDYNheight width:(DYNiniExplorerWidth - 108) pos:[13,78]
  label LBDYNdia2   width:(DYNiniExplorerWidth - 108) pos:[13,99]
  label LBDYNdia1   width:(DYNiniExplorerWidth - 108) pos:[13,120]
  label LBDYNkink1  width:(DYNiniExplorerWidth - 108) pos:[13,141]
  label LBDYNkink2  width:(DYNiniExplorerWidth - 108) pos:[13,162]
  label LBDYNdepth  width:(DYNiniExplorerWidth - 108) pos:[13,183]

  spinner SPDYNheight range:[0,1000,13.0]      type:#worldunits fieldwidth:60 pos:[(DYNiniExplorerWidth - 96),78]
  spinner SPDYNdia2   range:[0.01,1000.0,0.09] type:#worldunits fieldwidth:60 pos:[(DYNiniExplorerWidth - 96),99] scale:0.01
  spinner SPDYNdia1   range:[0.01,1000.0,0.16] type:#worldunits fieldwidth:60 pos:[(DYNiniExplorerWidth - 96),120] scale:0.01
  spinner SPDYNkink1  range:[0.1,1000,5.75]    type:#worldunits fieldwidth:60 pos:[(DYNiniExplorerWidth - 96),141]
  spinner SPDYNkink2  range:[0.01,1000,0.25]   type:#worldunits fieldwidth:60 pos:[(DYNiniExplorerWidth - 96),162]
  spinner SPDYNdepth  range:[0.1,1000,1.50]    type:#worldunits fieldwidth:60 pos:[(DYNiniExplorerWidth - 96),183]

  groupbox GBDYN03 width:(DYNiniExplorerWidth - 21) height:103 pos:[4,210]
  checkbox CKDYNleftArm   width:(DYNiniExplorerWidth - 120) pos:[13,229]
  checkbox CKDYNrightArm  width:(DYNiniExplorerWidth - 120) pos:[100,229]
  label LBDYNradius       width:(DYNiniExplorerWidth - 108) pos:[13,249]
  label LBDYNangle        width:(DYNiniExplorerWidth - 108) pos:[13,270]
  label LBDYNarmLen       width:(DYNiniExplorerWidth - 108) pos:[13,291]
  spinner SPDYNradius "" range:[0.1,1000.0,0.35]   type:#worldunits fieldwidth:60 scale:0.05 pos:[(DYNiniExplorerWidth - 96),249]
  spinner SPDYNangle  "" range:[10,90,80]          type:#worldunits fieldwidth:60 scale:1.0  pos:[(DYNiniExplorerWidth - 96),270]
  spinner SPDYNarmLen "" range:[0.01,1000.0,1.100] type:#worldunits fieldwidth:60 scale:0.1  pos:[(DYNiniExplorerWidth - 96),291]

  groupbox GBDYN04     width:(DYNiniExplorerWidth - 21)   pos:[4,318] height:61
  checkbox CKDYNonOff  width:(DYNiniExplorerWidth - 120)  pos:[13,337]
  label LBDYNheadScale width:(DYNiniExplorerWidth - 120)  pos:[13,357]
  spinner SPDYNheadScaleX "" range:[0.1,1000.0,1.0] fieldwidth:32 scale:0.1 pos:[99,357]
  spinner SPDYNheadScaleY "" range:[0.1,1000.0,1.0] fieldwidth:32 scale:0.1 pos:[142,357]

  groupbox GBDYN05        width:(DYNiniExplorerWidth - 21) height:72  pos:[4,384]
  checkbutton CBDYNlinked width:(DYNiniExplorerWidth - 39) highlightColor:DYNINIhighlightColor pos:[13,403]
  pickbutton PKDYNlink    width:(DYNiniExplorerWidth - 39) highlightColor:DYNINIhighlightColor filter:DYNFUNvspLampFilter pos:[13,429]

  ---SECTION 4 - DEFINE PANEL ACTIONS---
  on DYNlampParams open do
  (
    DYNlampParams.title = DYNuiRolloutNames[24]

    GBDYN01.text        = DYNuiResourcesGroups[69]
    GBDYN02.text        = DYNuiResourcesGroups[59]
    GBDYN03.text        = DYNuiResourcesGroups[70]
    GBDYN04.text        = DYNuiResourcesGroups[71]
    GBDYN05.text        = DYNuiResourcesGroups[1]

    LBDYNheight.text    = DYNuiResourcesLabels[200]
    LBDYNdepth.text     = DYNuiResourcesLabels[201]
    LBDYNdia2.text      = DYNuiResourcesLabels[227]
    LBDYNdia1.text      = DYNuiResourcesLabels[228]
    LBDYNkink1.text     = DYNuiResourcesLabels[229]
    LBDYNkink2.text     = DYNuiResourcesLabels[230]
    CKDYNleftArm.text   = DYNuiResourcesLabels[231]
    CKDYNrightArm.text  = DYNuiResourcesLabels[232]
    LBDYNradius.text    = DYNuiResourcesLabels[233]
    LBDYNangle.text     = DYNuiResourcesLabels[234]
    LBDYNarmLen.text    = DYNuiResourcesLabels[235]
    CKDYNonOff.text     = DYNuiResourcesLabels[22]
    LBDYNheadScale.text = DYNuiResourcesLabels[236]

    PKDYNlink.text      = DYNuiResourcesButtons[24]
  )

  on DYNlampParams close do
  (
    LOCobj = undefined
  )

  on SPDYNheight changed arg do
  (
    LOCallowHeight = DYNFUNcalcColumnHeadHeight LOCobj.baseObject.radius LOCobj.baseObject.angle LOCobj.baseObject.armLen
    LOCobj.baseObject.height = arg
    DYNFUNlampSpinnerLimits LOCobj LOCallowHeight
  )

  on SPDYNradius changed arg do
  (
    LOCallowHeight = DYNFUNcalcColumnHeadHeight LOCobj.baseObject.radius LOCobj.baseObject.angle LOCobj.baseObject.armLen
    LOCobj.baseObject.radius = arg
    DYNFUNlampSpinnerLimits LOCobj LOCallowHeight
  )
  on SPDYNarmLen changed arg do
  (
    LOCallowHeight = DYNFUNcalcColumnHeadHeight LOCobj.baseObject.radius LOCobj.baseObject.angle LOCobj.baseObject.armLen
    LOCobj.baseObject.armLen = arg
    DYNFUNlampSpinnerLimits LOCobj LOCallowHeight
  )
  on SPDYNangle  changed arg do
  (
    if arg < 10.0 then arg = 10.0
    LOCallowHeight = DYNFUNcalcColumnHeadHeight LOCobj.baseObject.radius LOCobj.baseObject.angle LOCobj.baseObject.armLen
    LOCobj.baseObject.angle  = arg
    DYNFUNlampSpinnerLimits LOCobj LOCallowHeight
  )

  on SPDYNkink1 changed arg do
  (
    LOCobj.baseObject.kink1  = arg
    DYNFUNlampSpinnerLimits LOCobj LOCallowHeight
  )

  on SPDYNkink2 changed arg do
  (
    LOCobj.baseObject.kink2  = arg
    DYNFUNlampSpinnerLimits LOCobj LOCallowHeight
  )

  on SPDYNdepth      changed arg do LOCobj.baseObject.depth      = arg
  on SPDYNheadScaleX changed arg do LOCobj.baseObject.headScaleX = arg
  on SPDYNheadScaleY changed arg do LOCobj.baseObject.headScaleY = arg * 4.0
  on CKDYNleftArm    changed arg do LOCobj.baseObject.leftArm    = arg
  on CKDYNrightArm   changed arg do LOCobj.baseObject.rightArm   = arg
  on CKDYNonOff      changed arg do LOCobj.baseObject.onOff      = arg
  on SPDYNdia1       changed arg do LOCobj.baseObject.dia1       = arg
  on SPDYNdia2       changed arg do
  (
    LOCobj.baseObject.dia2   = arg
    if LOCobj.baseObject.radius < (LOCobj.baseObject.dia2 / 2) then LOCobj.baseObject.radius = LOCobj.baseObject.dia2 / 2
    DYNFUNlampSpinnerLimits LOCobj LOCallowHeight
  )

  on DDDYNtype selected arg do
  (
    undo off
    (
      LOCobj.baseObject.matID  = arg
      setAppData LOCobj 423 (arg as string)
      DYNproperties.DYNFUNupdPropertiesPanel()
    )
  )

  on CBDYNlinked changed arg do
  (
    if arg == false then
    (
      LOCobj = DYNFUNunlinkNodeInstance DYNlampParams LOCobj 2 false
      select LOCobj
    )
  )

  on PKDYNlink picked arg do
  (
    if arg != LOCobj then
    (
      LOCobj = DYNFUNunlinkNodeInstance DYNlampParams LOCobj 2 true
      instanceReplace LOCobj arg
      select LOCobj
    )
  )
)
